<?php
include("sess_check.php");

// deskripsi halaman
$pagedesc = "Tingkatan";
include("layout_top.php");
include("dist/function/format_tanggal.php");
include("dist/function/format_rupiah.php");
?>
<!-- top of file -->
<!-- Page Content -->
<div id="page-wrapper">
	<div class="container-fluid">
		<div class="row">
			<div class="col-lg-12">
				<h1 class="page-header">Data Tingkatan</h1>
			</div><!-- /.col-lg-12 -->
		</div><!-- /.row -->

		<div class="row">
			<div class="col-lg-12"><?php include("layout_alert.php"); ?></div>
		</div>

		<div class="row">
			<div class="col-lg-12">
				<div class="panel panel-default">
					<div class="panel-heading">
						<a href="tingkatan_tambah.php" class="btn btn-success">Tambah</a>
					</div>
					<div class="panel-body">
						<table class="table table-striped table-bordered table-hover" id="tabel-data">
							<thead>
								<tr>
									<th width="1%">No</th>
									<th width="10%">Id Tingkatan</th>
									<th width="10%">Tingkatan Kelas</th>
									<th width="10%">Tahun Ajaran</th>
									<th width="10%">Opsi</th>
								</tr>
							</thead>
							<tbody>
								<?php
								$i = 1;
								$sql = "SELECT tingkatan.*, masuk.*, status.* FROM tingkatan, masuk, status WHERE tingkatan.id_tahun=masuk.id_tahun AND status.id_status=masuk.id_status AND status.status BETWEEN 'Aktif' AND 'Aktif' ORDER BY tingkatan.id_tingkatan ASC";
								$ress = mysqli_query($conn, $sql);
								while ($data = mysqli_fetch_array($ress)) {
									echo '<tr>';
									echo '<td class="text-center">' . $i . '</td>';
									echo '<td class="text-center">' . $data['id_tingkatan'] . '</td>';
									echo '<td class="text-center">' . $data['tingkatan'] . '</td>';
									echo '<td class="text-center">' . $data['tahun_ajaran'] . '</td>';
									echo '<td class="text-center">
													  <a href="tingkatan_edit.php?tingkatan=' . $data['id_tingkatan'] . '" class="btn btn-warning btn-xs">Edit</a>'; ?>
									<a href="tingkatan_hapus.php?tingkatan=<?php echo $data['id_tingkatan']; ?>" onclick="return confirm('Apakah anda yakin akan menghapus <?php echo $data['tingkatan']; ?>?');" class="btn btn-danger btn-xs">Hapus</a></td>
								<?php
									echo '</td>';
									echo '</tr>';
									$i++;
								}
								?>
							</tbody>
						</table>
					</div>
					<!-- Large modal -->
					<div class="modal fade bs-example-modal" id="myModal" tabindex="-1" role="dialog" aria-hidden="true">
						<div class="modal-dialog modal-lg">
							<div class="modal-content">
								<div class="modal-body">
									<p>One fine body…</p>
								</div>
							</div>
						</div>
					</div>
				</div><!-- /.panel -->
			</div><!-- /.col-lg-12 -->
		</div><!-- /.row -->
	</div><!-- /.container-fluid -->
</div><!-- /#page-wrapper -->
<!-- bottom of file -->
<script type="text/javascript">
	$(document).ready(function() {
		$('#tabel-data').DataTable({
			"responsive": true,
			"processing": true,
			"columnDefs": [{
				"orderable": false,
				"targets": [4]
			}]
		});

		$('#tabel-data').parent().addClass("table-responsive");
	});
</script>
<script>
	var app = {
		code: '0'
	};

	$('[data-load-code]').on('click', function(e) {
		e.preventDefault();
		var $this = $(this);
		var code = $this.data('load-code');
		if (code) {
			$($this.data('remote-target')).load('karyawan_detail.php?code=' + code);
			app.code = code;

		}
	});
</script>
<?php
include("layout_bottom.php");
?>